######### Cria Planilhas Sisflora e DOF e fusiona todas em uma nica planilha    ###############
#########                       Anos de 2012 a 2017                              ###############

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Carrega os pacotes necessrio para ler os arquivos
library(data.table)
library(openxlsx)
library(dplyr)
library(tidyr)
library(stringi)

  
######################################## Sisflora PA 2.0 ##########################################
   
# Lista os arquivos do diretrio e cria o objeto "lista" com os nomes dos arquivos de 
# exteno .xlsx que comeam com "PA". Deve-se atentar para os arquivos .xsls includos na
# pasta de trabalho

    
getwd()         # O diretrio mostrado deve ser o mesmo do arquivo "1. DOF e Sisflora.R" 
setwd("./PA SISFLORA 2.0")    

lista <- list.files(pattern=".csv")
lista <- lista[grepl("^[PA]",lista)]        # o comando grepl indica que queremos apenas os arquivos .xlsx cujos nomes se iniciam com as letras "PA".
    
pa2.0 <- data.table()
for (i in 1:length(lista)) {
            x <- fread(lista[i], select = c("TIPO_GF", 
                                            "STATUS_GF", 
                                            "UF_REMETENTE", 
                                            "MUNICPIO_REMETENTE", 
                                            "TIPO_DESTINO", 
                                            "CEPROF_DESTINATRIO", 
                                            "UF_DESTINATRIO", 
                                            "MUNICPIO_DESTINATRIO", 
                                            "N_AUTORIZAO",
                                            "PROCESSO",
                                            "EMISSAO", 
                                            "NOME_CIENTFICO", 
                                            "PRODUTO",
                                            "VOLUME", 
                                            "UNID", 
                                            "PRECO_TOTAL"),
                       col.names = c("Tipo.de.Guia",
                                     "Status.Guia",
                                     "UF.Origem",
                                     "Municipio.Origem",
                                     "Exportacao",
                                     "Cadastro.Destino",
                                     "UF.Destino",
                                     "Municipio.Destino",
                                     "Autorizacao",
                                     "Processo",
                                     "Emissao",
                                     "Especie",
                                     "Produto",
                                     "Volume.Total",
                                     "Unidade",
                                     "Preco.Total"))         # a funo fread do pacote data.table() l arquivos .csv mais rapidamente.
            pa2.0 <- rbind(pa2.0, x)                                                # fusiona as planilhas intermediria para formar uma nica planilha pa2.0
        }
        rm (x, i, lista)
        
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas no argumento
# "by". Ao final do comando, as variveis "VOLUME" e "PRECO_TOTAL" sero renomeadas para
# V1 e V2, respectivamente.
    pa2.0 <- pa2.0[, .(sum(Volume.Total), sum(Preco.Total)),
                             by = .(Tipo.de.Guia,
                                    Status.Guia,
                                    UF.Origem,
                                    Municipio.Origem,
                                    Exportacao,
                                    Cadastro.Destino,
                                    UF.Destino,
                                    Municipio.Destino,
                                    Autorizacao,
                                    Processo,
                                    Emissao,
                                    Especie,
                                    Produto,
                                    Unidade)]
        
   
## Incluir a coluna "Tipo de Autorizao" na planilha pa2.0:
    
# L planilha Saldos ACT/ACP
    act <- fread("saldoActAcp 10-01-2008 (simplificado).csv",
                 header = TRUE,
                 select = c("N_AUTORIZAO", 
                            "N_PROCESSO", 
                            "TIPO_CRDITO"),
                 col.names = c("N_AUTORIZAO", 
                                "N_PROCESSO", 
                                "TIPO_CRDITO"))    # o argumento select permite escolher colunas especficas para serem lidas.
                                                    # Gera o nmero de ocorrncias de cada uma das combinaoes das variveis nmero de autorizao,
                                                    # nmero de processo e tipo de crdito


    act <- act[, .N, keyby = .(N_AUTORIZAO, N_PROCESSO, TIPO_CRDITO)]    # o argumento ".N" lista, em uma data.table, o nmero de ocorrncias de cada uma das combinaes de valores das varivei passadas no argumento "keyby". 
                                                                            #Keyby poderia ser substitudo por by. A diferena  que o resultado utilizando keyby sai de forma ordenada.
        
# Inclui a varivel "TIPO_CRDITO" ao final da planilha pa2.0
    pa2.0 <- merge(pa2.0, act, by.x = c("Autorizacao", "Processo"), 
                   by.y = c("N_AUTORIZAO", "N_PROCESSO"), all.x = TRUE)
        
    rm(act)                                                                 # remove a planilha act
    
# Elimina as colunas N_AUTORIZAO, PROCESSO e N.
    pa2.0 <- select(pa2.0, -Autorizacao, -Processo, -N)
    
# Renomeia colunas de pa2.0.
    pa2.0 <- rename(pa2.0,
                    "Volume.Total" = "V1",
                    "Preco.Total" = "V2",
                    "Tipo.de.Origem" = "TIPO_CRDITO")
    
    # salva pa2.0 em uma planilha .csv
    write.csv(pa2.0, file ="SisfloraPA_2.0.csv")
       
        
###################################### Sisflora PA 1.0 ############################################

# Lista os arquivos do diretrio e cria o objeto "lista"
        setwd("..")                         # sobe um diretrio para retornar ao diretrio inicial do script
        setwd("./PA SISFLORA 1.0")    
lista <- list.files(pattern=".csv")
lista <- lista[grepl("^[PA]",lista)]        # o comando grepl indica que queremos apenas os arquivos .xlsx cujos nomes se iniciam com as letras "PA".
        
# L as planilhas como data.table() e as fusiona mantendo as colunas listadas no argumento select da funo fread:

pa1.0 <- data.table()
for (i in 1:length(lista)) {
        x <- fread(lista[i], select = c("Tipo", 
                                        "Status",
                                        "Origem",
                                        "UF.Remetente",
                                        "Municpio.Remetente",
                                        "Exportao",
                                        "CEPROF.Destinatrio",
                                        "UF.Destinatrio",
                                        "Municpio.Destinatrio",
                                        "Emisso",
                                        "Nome.Cientfico",
                                        "Produto", 
                                        "Volume",
                                        "Unid",
                                        "Preo.Total.R$"),
                   col.names = c("Tipo.de.Guia",
                                 "Status.Guia",
                                 "Tipo.de.Origem",
                                 "UF.Origem",
                                 "Municipio.Origem",
                                 "Exportacao",
                                 "Cadastro.Destino",
                                 "UF.Destino",
                                 "Municipio.Destino",
                                 "Emissao",
                                 "Especie",
                                 "Produto",
                                 "Volume.Total",
                                 "Unidade",
                                 "Preco.Total"))       
                pa1.0 <- rbind(pa1.0, x)                                               
        }
        rm (x, i, lista)        
        

# Agrega a soma do volume total e do preo total conforme as colunas escolhidas no argumento
# "by". Ao final do comando, as variveis "VOLUME" e "PRECO_TOTAL" sero renomeadas para
# V1 e V2, respectivamente.
      pa1.0 <- pa1.0[, .(sum(Volume.Total), sum(Preco.Total)),
                       by = .(Tipo.de.Guia,
                              Status.Guia,
                              Tipo.de.Origem,
                              UF.Origem,
                              Municipio.Origem,
                              Exportacao,
                              Cadastro.Destino,
                              UF.Destino,
                              Municipio.Destino,
                              Emissao,
                              Especie,
                              Produto,
                              Unidade)]
      
# Renomeia coliunas de pa1.0. 
    pa1.0 <- rename(pa1.0,
                    "Volume.Total" = "V1",
                    "Preco.Total" = "V2")
      

    write.csv(pa1.0, file ="SisfloraPA_1.0.csv")
      
#Fusiona pa1.0 com pa2.0
    pa <- rbind(pa1.0,pa2.0)
    
# Elimina as planilhas intermedirias
    rm(pa1.0, pa2.0)
    
# Converter a classe da coluna emisso para data:
    pa$Emissao <- data.frame(data.frame(as.Date(pa$Emissao, 
                                              format = "%d/%m/%Y", 
                                              origin = "30/12/1899"))) # o formato passado aqui  referente  data informada no argumento origin.
    
# Formatar data para mostrar apenas o ano:          # ver https://www.statmethods.net/input/dates.html para formatos de datas
    pa$Emissao <- format(pa$Emissao, format = "%m-%Y")   # Formato jan/2012: sisflora$Emisso <- format(sisflora$Emisso, format="%b/%Y")
    
    write.csv(pa, file = "SisfloraPA_2012_2017.csv")
    
############################################# Sisflora MT #########################################
      
# Lista os arquivos do diretrio e cria o objeto "lista"
    setwd("..")
    setwd("./MT SISFLORA")    
    lista <- list.files(pattern=".csv")
    lista <- lista[grepl("^[MT]",lista)]        # o comando grepl indica que queremos apenas os arquivos .xlsx cujos nomes se iniciam com as letras "PA".
    
# Converte os arquivos .xlsx de uma pasta em .csv
    
# L as planilhas como data.table() e as fusiona mantendo as colunas listadas no argumento select da funo fread:
    
    mt <- data.table()
    for (i in 1:length(lista)) {
        x <- fread(lista[i], select = c("Tipo", 
                                        "Status",
                                        "Origem",
                                        "UF.Remetente",
                                        "Municpio.Remetente",
                                        "Exportao",
                                        "CC-SEMA.Destinatrio",
                                        "UF.Destinatrio",
                                        "Municpio.Destinatrio",
                                        "Emisso",
                                        "Nome.Cientfico",
                                        "Produto", 
                                        "Volume",
                                        "Unid",
                                        "Preo.Total.R$"),
                   col.names = c("Tipo.de.Guia",
                                 "Status.Guia",
                                 "Tipo.de.Origem",
                                 "UF.Origem",
                                 "Municipio.Origem",
                                 "Exportacao",
                                 "Cadastro.Destino",
                                 "UF.Destino",
                                 "Municipio.Destino",
                                 "Emissao",
                                 "Especie",
                                 "Produto",
                                 "Volume.Total",
                                 "Unidade",
                                 "Preco.Total"))       
        mt <- rbind(mt, x)                                              
    }
    rm (i, x, lista)
    
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas no argumento
# "by". Ao final do comando, as variveis "VOLUME" e "PRECO_TOTA"L sero renomeadas para
# V1 e V2, respectivamente.
    mt <- mt[, .(sum(Volume.Total), sum(Preco.Total)),
                   by = .(Tipo.de.Guia,
                          Status.Guia,
                          Tipo.de.Origem,
                          UF.Origem,
                          Municipio.Origem,
                          Exportacao,
                          Cadastro.Destino,
                          UF.Destino,
                          Municipio.Destino,
                          Emissao,
                          Especie,
                          Produto,
                          Unidade)]
    
# Renomeia mt. Primeiro como teste para pa2.2, depois definitivamente para pa2.0
    mt <- rename(mt,
                 "Volume.Total" = "V1",
                 "Preco.Total" = "V2")
    
# Converter a classe da coluna "Emisso" para Date:
    mt$Emissao <- data.frame(as.Date(mt$Emissao, "%d/%m/%Y %H:%M:%S"))
    
# Formatar data para mostrar apenas o ano:
    mt$Emissao <- format(mt$Emissao, format = "%m-%Y")

# Cria planilha  MT    
    write.csv(mt, file ="SisfloraMT_2012_2017.csv")
    
#################################### Sisflora Geral (MT e PA) #####################################
    

    setwd("..")     

# Fusiona todas as planilhas mt e pa em uma nica
    sisflora <- rbind(mt, pa)
    
# Considerar apenas as movimentaes cujas guias tm os valores "Recebido", "RECEBIDO" e "RECEBIDO_VENCIDO".
    sisflora <- sisflora[(sisflora$Status.Guia=="Recebido" | 
                            sisflora$Status.Guia=="RECEBIDO" |
                            sisflora$Status.Guia== "RECEBIDO_VENCIDO"),]
    
# Elimina a coluna Status.Guia
    sisflora <- select(sisflora, -Status.Guia)
      
# Cria arquivo Sisflora_2012_2017_Original, antes de eliminar as movimentaes que no so intraestaduais
    write.csv(sisflora, file ="Sisflora_2012_2017_Original.csv")
      
# Elimina as planilhas intermedirias
    rm(mt, pa)
      
# Cria o subset das movimentaes intraestaduais de MT ou PA e que sejam expotao ou 
# importao e as movimentaes interestaduais para comparar os volumes com as mesmas 
# movimentaes do DOF.
      
# Retira as exportaes
    sisflora <- sisflora[!(sisflora$Exportacao=="Sim" |
                             sisflora$Exportacao=="EXPORTACAO"),]

# Elimina a coluna Exportao e cria a coluna Pas.Destino com valores "Brasil", 
# j que as exportaes viro do DOF.
    sisflora <- as.data.table(mutate(sisflora, 
                       Pais.Destino = "Brasil",
                       Exportacao = NULL))
      
# Troca os valores nulos na coluna "Cadastro.Destino" por "Consumidor Final"
    sisflora$Cadastro.Destino[is.na(sisflora$Cadastro.Destino)] <- "Consumidor.Final"
    sisflora$Cadastro.Destino[sisflora$Cadastro.Destino != "Consumidor.Final"] <- "Sisflora.Outros"
      
     
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas
    sisflora <- sisflora[, .(sum(Volume.Total), sum(Preco.Total)),
                         by = .(Tipo.de.Guia,
                                Tipo.de.Origem,
                                UF.Origem,
                                Municipio.Origem,
                                Cadastro.Destino,
                                Pais.Destino,
                                UF.Destino,
                                Municipio.Destino,
                                Emissao,
                                Especie,
                                Produto,
                                Unidade)]

# Renomeia as colunas V1 e V2  
    sisflora <- rename(sisflora,
                       "Volume.Total" = "V1",
                       "Preco.Total" = "V2")
    
    
 
# Salva arquivo   
    write.csv(sisflora, file ="Sisflora_2012_2017.csv")
          
    
############################################### DOF Mensal ################################################
    
# Lista os arquivos do diretrio e cria o objeto "lista"
    
    setwd("./DOF_Mensal_abr2018")    

    # L as planilhas como data.table() e as fusiona mantendo as seguintes colunas:
    lista <- list.files(pattern=".dsv")
    lista <- lista[grepl("^[DOF]",lista)]
    dof <- data.table()
    
    for (i in 1:length(lista)) {
        x <- fread(lista[i], 
                   col.names = c("Ano",
                                 "Mes",
                                 "Tipo.de.Origem",
                                 "UF.Origem",
                                 "Municipio.Origem",
                                 "UF.Destino",
                                 "Municipio.Destino",
                                 "Pais.Destino",
                                 "Tipo.de.Guia",
                                 "Produto",
                                 "Especie",
                                 "Unidade",
                                 "Volume.Total",
                                 "Preco.Total",
                                 "DOFs.Total"),
                   encoding = "Latin-1",
                   sep = ";",
                   dec = ",")                    
        dof <- rbind(dof, x)                         
    }
    
    rm (x, i, lista)    
    
 # Elimina a colunas DOFs.Total
    dof <- select(dof, -DOFs.Total)
    
# Grava .csv
    write.csv(dof, "Dof 2012 a 2017_Original.csv")
    
# Cria a coluna Emisso aps fusionar ano e mes
    dof <- as.data.table(mutate(dof, Emissao = paste(dof$Mes, dof$Ano, sep = "-")))
    
# Elimina a colunas Ano e Mes
    dof <- select(dof, -Ano, -Mes)
    
# Converte a classe da coluna "Emisso" para Data. Para que o R converta um caracer em data, ele precisa ter o dia, mes e ano. 
# Dessa forma, a funo paste0 foi utilizada para inserir um 01 no incio para todos os valores de data vindos do DOF.
    dof$Emissao <- as.Date(paste0("01","-", dof$Emissao),"%d-%m-%Y")
    
# Formatar data para mostrar apenas o mes e o ano:
    dof$Emissao <- format(dof$Emissao, format = "%m-%Y")
    
## Troca os valores da coluna Tipo.de.Guia conforme as seguintes instrues:

    dof$Tipo.de.Guia[dof$Tipo.de.Guia=="DOFCF"] <- "DOF.Isento.de.CTF"
    dof$Tipo.de.Guia[dof$Tipo.de.Guia=="DOFEWS"] <- "Guia.Estadual"
    dof$Tipo.de.Guia[dof$Tipo.de.Guia=="DOFEXP"] <- "DOF.Exportacao"
    dof$Tipo.de.Guia[dof$Tipo.de.Guia=="DOFIMP"] <- "DOF.Importacao"
    dof$Tipo.de.Guia[dof$Tipo.de.Guia=="DOFEXP"] <- "DOF.Exportacao"

## Troca os valores da coluna Tipo.de.Origem conforme as seguintes instrues:
    dof$Tipo.de.Origem <- sub("^PATIO(.*)", "Patio",dof$Tipo.de.Origem)                     # substitui tudo que comea com PATIO por Patio
    dof$Tipo.de.Origem <- sub("^DI(.*)", "Declaracao.de.Importacao", dof$Tipo.de.Origem)    # substitui tudo que comea com DI por Declaracao.de.Importacao
    
# Harmoniza nomes para minusculo e troca espaos vazios por "."
    dof$Tipo.de.Origem[dof$Tipo.de.Origem == "SALDONAOEXPORTADO"] <- "Saldo.Nao.Exportado"
    dof$Tipo.de.Origem[dof$Tipo.de.Origem == "Sistema Estadual"] <- "Sistema.Estadual"
    dof$Tipo.de.Origem[dof$Tipo.de.Origem == "Corte de rvores Isoladas"] <- "Corte.de.Arvores.Isoladas"
    dof$Tipo.de.Origem[dof$Tipo.de.Origem == "Uso Alternativo do Solo"] <- "Uso.Alternativo.do.Solo"
    dof$Tipo.de.Origem[dof$Tipo.de.Origem == "Floresta Plantada"] <- "Floresta.Plantada"
    dof$Tipo.de.Origem[dof$Tipo.de.Origem == "Autorizao de Supresso de Vegetao"] <- "Autorizacao.de.Supressao.de.Vegetacao"
    
# Reduzir o nome de resduos:
    dof$Produto[dof$Produto == "Resduo da Indstria Madeireira para Fins de Aproveitamento Industrial"] <- "Residuo.para.Aproveitamento.Industrial"
    dof$Produto[dof$Produto == "Resduo da Indstria Madeireira para Fins Energticos"] <- "Residuo.para.Fins.Energeticos"
    
# Troca os valores nulos na coluna Pas.Destino por "Brasil"
    dof$Pais.Destino[dof$Pais.Destino==""] <- "Brasil"
    
# Adiciona a coluna Cadastro.Destino com valores "DOF.Outros"
    dof$Cadastro.Destino <- "DOF.Outros"
    
# Retira as movimentaes intra e interestaduais do MT e PA que tenham o Brasil como Pas de Destino
# Dessa forma, para as movimentaes com origem no MT ou no PA, o DOF vai fornecer apenas 
# as movimentaes que tem pases estrangeiros como destinatrios. As movimentaes brasileiras
# com origem nesses estados viro do Sisflora MT e PA
    dof <- dof[!((dof$UF.Origem=="MT" & dof$Pais.Destino=="Brasil") |
                     (dof$UF.Origem=="PA" & dof$Pais.Destino=="Brasil")),]
    
# Troca os valores "Outros" na coluna "Cadastro.Destino" por "Consumidor Final". 
# Considera DOF Exportao ou Guias Estaduais com pases estrangeiros como destinatrios. 
    dof$Cadastro.Destino[dof$Tipo.de.Guia == "DOF.Isento.de.CTF"] <- "Consumidor.Final"
    dof$Cadastro.Destino[dof$Tipo.de.Guia == "DOF.Exportacao"] <- "Consumidor.Final"
    dof$Cadastro.Destino[(dof$Tipo.de.Guia == "Guia.Estadual" &
                              dof$Pais.Destino != "Brasil")] <- "Consumidor.Final"
    
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas
    dof <- dof[, .(sum(Volume.Total), sum(Preco.Total)),
                         by = .(Tipo.de.Guia,
                                Tipo.de.Origem,
                                UF.Origem,
                                Municipio.Origem,
                                Cadastro.Destino,
                                Pais.Destino,
                                UF.Destino,
                                Municipio.Destino,
                                Emissao,
                                Especie,
                                Produto,
                                Unidade)]
    
# Renomeia as colunas V1 e V2  
    dof <- rename(dof,
                       "Volume.Total" = "V1",
                       "Preco.Total" = "V2")
    
# Cria o arquivo .csv da planilha DOF  
    write.csv(dof, file ="Dof 2012 a 2017.csv")
    
############################### Sisdof: Fusiona Sisflora com DOF ##################################

# Muda o diretrio de trabalho
    setwd("..")
    
# Fusiona sisflora com DOF, criando a planilha "sisdof"
    sisdof <- rbind(sisflora, dof)
    rm(dof, sisflora)
    
    write.csv(sisdof, file = "Movimentacao Geral 2012 a 2017_Original.csv")
    
############################### Padronizao de caracteres ##################################  

#### 1. Municipio.Origem ####
    
# Todas para maiscula
    sisdof$Municipio.Origem <- toupper(sisdof$Municipio.Origem)
# Elimina os acentos ortogrficos
    sisdof$Municipio.Origem <- stri_trans_general(sisdof$Municipio.Origem, "Latin-ASCII")
# Troca espaos por "."
    sisdof$Municipio.Origem <- gsub("\\s+", ".", sisdof$Municipio.Origem)
# Deletar "." no final, se houver
    # grep("\\.$", sisdof$Municipio.Origem)   #Testa se h municpios com "." no final, caso positivo executar o comando abaixo:
    sisdof$Municipio.Origem <- gsub("\\.$", "", sisdof$Municipio.Origem)
    
#### 2. Cadastro.Destino ####
# Substitui "Sisflora.Outros" e "DOF.Outros" por Produtor ou Consumidor Intermedirio.
    sisdof$Cadastro.Destino[sisdof$Cadastro.Destino == "Sisflora.Outros"] <- "Produtor.ou.Consumidor.Intermediario"
    sisdof$Cadastro.Destino[sisdof$Cadastro.Destino == "DOF.Outros"] <- "Produtor.ou.Consumidor.Intermediario"
    
#### 3. Pais.Destino ####
    

# Todas para maiscula
    sisdof$Pais.Destino <- toupper(sisdof$Pais.Destino)
# Elimina os acentos ortogrficos
    sisdof$Pais.Destino <- stri_trans_general(sisdof$Pais.Destino, "Latin-ASCII")
# Troca espaos por "."
    # grep("\\s+", sisdof$Pais.Destino)
    sisdof$Pais.Destino <- gsub("\\s+", ".", sisdof$Pais.Destino)
# Deletar "." no final, se houver
    # grep("\\.$", sisdof$Pais.Destino)   #Testa se h municpios com "." no final, caso positivo executar o comando abaixo:
    sisdof$Pais.Destino <- gsub("\\.$", "", sisdof$Pais.Destino)
    
    
#### 4. Municipio.Destino ####
    
# Todas para maiscula
    sisdof$Municipio.Destino <- toupper(sisdof$Municipio.Destino)
# Elimina os acentos ortogrficos
    sisdof$Municipio.Destino <- stri_trans_general(sisdof$Municipio.Destino, "Latin-ASCII")
# Troca espaos por "."
    sisdof$Municipio.Destino <- gsub("\\s+", ".", sisdof$Municipio.Destino)
# Deletar "." no final, se houver
    # grep("\\.$", sisdof$Municipio.Destino)   #Testa se h municpios com "." no final, caso positivo executar o comando abaixo:
    sisdof$Municipio.Destino <- gsub("\\.$", "", sisdof$Municipio.Destino)

#### 5. Emisso ####
    
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas
    sisdof <- sisdof[, .(sum(Volume.Total), sum(Preco.Total)),
               by = .(Tipo.de.Guia,
                      Tipo.de.Origem,
                      UF.Origem,
                      Municipio.Origem,
                      Cadastro.Destino,
                      Pais.Destino,
                      UF.Destino,
                      Municipio.Destino,
                      Emissao,
                      Especie,
                      Produto,
                      Unidade)]

# Renomeia as colunas V1 e V2  
    sisdof <- rename(sisdof,
                  "Volume.Total" = "V1",
                  "Preco.Total" = "V2")
    
# Cria o arquivo .csv sisdof aps as modificaes nas colunas 1 a 9.  
    write.csv(sisdof, file = "Movimentacao Geral 2012 a 2017_1 a 9.Emissao.csv")
    
#### 6. Especies ####
    
# Troca os valores nulos na coluna Espcie por "Nao Informado"
    sisdof$Especie[sisdof$Especie == ""] <- "Nao.Informado"
# Troca os valores "Diversos" na coluna Espcie por "No Informado"
    sisdof$Especie[sisdof$Especie == "Diversos"] <- "Nao.Informado"
    
# Primeira letra para maiscula
    sisdof$Especie <- tolower(sisdof$Especie)
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    sisdof$Especie <- capFirst(sisdof$Especie) 
    
# Troca espaos duplos por " "
    # length(grep("\\s{2,}", sisdof$Especie))
    sisdof$Especie <- gsub("\\s{2,}", " ", sisdof$Especie)
    
# Deleta espao no final
    # length(grep("\\s+$", sisdof$Especie))
    sisdof$Especie <- gsub("\\s+$", "", sisdof$Especie)
    
# Elimina os acentos ortogrficos
    sisdof$Especie <- stri_trans_general(sisdof$Especie, "Latin-ASCII")
    
# Trocar spp. e variaes de maiuscula e minuscula por sp., se houver
    # length(grep("\\sspp\\.$", sisdof$Especie))
    sisdof$Especie <- sub("\\sspp\\.$", " sp\\.", sisdof$Especie)   
# Trocar spp e variaes de maiuscula e minuscula por sp.
    # length(grep("\\sspp$", sisdof$Especie))
    sisdof$Especie <- sub("\\sspp$", " sp\\.", sisdof$Especie)  
# Trocar sp e variaes de maiuscula e minuscula por sp.
    sisdof$Especie <- sub("\\s[Ss][Pp]$", " sp\\.", sisdof$Especie)
    
# Criar subset sisdof1. Eliminar de sisdof1 as que tem sp. no final e as que estao como 
# NAO.INFORMADO. Esse subset ser utilizado na funo gnr_resolve
    sisdof1 <- sisdof[grepl("\\ssp\\.$", sisdof$Especie) == FALSE,]
    sisdof1 <- sisdof1[sisdof1$Especie != "Nao.informado",]
    
# O outro subset sera fusionado posteriormente ao sisdof1
    sisdof2 <- sisdof[grepl("\\ssp\\.$", sisdof$Especie) == TRUE,]  # subset de sisdof com as espcies com sp. no final
    sisdof3 <- sisdof[sisdof$Especie == "Nao.informado",]           # subset de sisdof1 em que os valores da coluna Especies  "Nao.informado"
    sisdof2 <- rbind(sisdof2, sisdof3)
    rm(sisdof3)
    
# Usar pacote taxize
    resolve <- as.data.table(data.frame(unique(sisdof1$Especie)))           # cria a planilha "resolve" como data.table. Essa planilha contm os nomes nicos de espcies de sisdof1. 
    resolve <- rename(resolve, Especie.Sisflora = unique.sisdof1.Especie.)  # renomeia a nica coluna de resolve para "Especie.Sisflora" 
    resolve$Especie.Sisflora <- as.character(resolve$Especie.Sisflora)      # muda a classe de resolve$Especie.Sisflora de factor para character
    resolve$Especie.Resolvida <- "Teste"                                    # cria a coluna "Especie.Resolvida" na planilha resolve com valores "Teste". Essa coluna ir receber os nomes gerados pela funo gnr_resolve() do pacote taxize
    
    
    # Loop que utiliza a funo gnr_resolve em cada um dos nomes de espcies da planilha
    # resolve para retornar o nome cientfico mais provvel. Dessa forma espera-se eliminar
    # erros de escrita nos nomes de espcies informados no DOF e no Sisflora MT e PA
    library(taxize)
    for (i in 1:length(resolve$Especie.Sisflora)) {
        x <- gnr_resolve(names = resolve$Especie.Sisflora[i])   # passa para x o resultado da funo resolve com a lista de espcies i do loop. Esse resultado  um data.frame. Estamos interessados na linha 1 da coluna 3 desse data.frame
        if (length(x) == 0) {                                   # se a funo gnr_resolve retorna uma data.frame vazia, 
            resolve$Especie.Resolvida[i] <- "Erro"              # ento o valor de Especie.Resolvida da planilha resolve ser "Erro".
        } else {
            resolve$Especie.Resolvida[i] <-x[[3]][1]            # caso a gnr_resolve retorne pelo menos uma linha, entao iremos passar o valor da primeira linha da terceira coluna de x para Especie.Resolvida da planilha resolve
        }
    }
    
# Encontrar os erros e achar a solucao. Nos casos em que a funo gnr_resolve retorna uma 
# data.frame vazia devemos resolver os nomes manualmente. 
    
# Cria o subset de resolve como resolve.erro. 
    resolve.erro <- resolve[resolve$Especie.Resolvida == "Erro",]
# Encontra os nomes nicos das espcies que a funo gnr_resolve no conseguiu resolver
    especie.erro <- unique(resolve.erro$Especie.Sisflora)
    
# Quando rodamos o script em maio de 2018 foram encontrados os seguintes erros, com as 
# alteraes propostas:
    
    # Castilha = Nao.Informado
    # Madeira usada/velha = Nao.Informado
    # Dypteryx = Dypteryx sp.
    # Diversas = Nao.Informado                  
    # Brosiminum angustifolium ducke = Brosimum angustifolium
    # Brosimin Guianense = Brosimum guianense
    # Louro-preto = Nao.Informado
    # Louro-rosa = Nao.Informado
    
# Substituir manualmente os erros da funo gnr_resolve:
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Castilha"] <- "Nao.Informado"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Madeira usada/velha"] <- "Nao.Informado"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Dypteryx"] <- "Dipteryx sp."
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Diversas"] <- "Nao.Informado"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Brosiminum angustifolium ducke"] <- "Brosimum angustifolium"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Brosimin Guianense"] <- "Brosimum guianense"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Louro-preto"] <- "Nao.Informado"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Louro-rosa"] <- "Nao.Informado"
    
# Dividir a coluna Especie em duas: Especie, com o primeiro nome e Resto com os outros nomes 
    resolve$Especie.Resolvida1 <- resolve$Especie.Resolvida
    resolve <- extract(resolve, Especie.Resolvida1, c("Especie", "Resto"), "([^ ]+) (.*)")
    resolve$Resto1 <- resolve$Resto
    resolve <- extract(resolve, Resto1, c("Resto1", "Resto2"), "([^ ]+) (.*)")

# Faz um loop para juntar novamente Espcie e Gnero
    for (i in 1:length(resolve$Especie.Resolvida)) {
        if (is.na(resolve$Especie[i] == TRUE) & is.na(resolve$Resto[i] == TRUE)) {   #Se Espcie e Resto forem vazios, retorna o nome do sisdof
            
            resolve$Especie2[i] <- resolve$Especie.Sisflora[i]
            
        } else if (is.na(resolve$Resto1[i]) == FALSE) {                               #Se apenas Resto1  vazio, junta Espcie1 com Resto. Esse  o caso quando a primeira divisao de colunas resultou em Gnero e Espcie.
            
            resolve$Especie2[i] <- paste(resolve$Especie[i], resolve$Resto1[i])
        }
        else {
            resolve$Especie2[i] <- resolve$Especie.Resolvida[i]   #Se Resto1 no for vazio estamos no caso de uma nomenclatura com mais de dois nomes. Nesse caso, iremos fusionar as colunas Espcie1 e Resto1
        } 
    }
    
# Exlui as colunas intermediarias de Especie e Resto
    resolve$Especie.Resolvida <- resolve$Especie2
    resolve <- select(resolve, -Especie, -Especie2, -Resto, -Resto1, -Resto2) 
    
# Substituir as espcie que foram trocadas por Nao.Informado antes do loop, j que esse passo desarrumou essa alterao
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Castilha"] <- "Nao.Informado"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Madeira usada/velha"] <- "Nao.Informado"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Diversas"] <- "Nao.Informado"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Louro-preto"] <- "Nao.Informado"
    resolve$Especie.Resolvida[resolve$Especie.Sisflora == "Louro-rosa"] <- "Nao.Informado"
    
# Grava resolve
    write.csv(resolve, "resolve_especie.csv")

# Achar nomes diferentes entre sisdof e Resolve
# Cria a coluna resolve$Identicos[i]. Se resolve$Especie.Sisflora[i] e 
# resolve$Especie.Resolvida[i] forem idnticos, retorna "Sim" na coluna resolve$Identicos.
# Caso contrrio, retorna "No"
    
    for (i in 1:length(resolve$Especie.Sisflora)) {
        
        if (identical(resolve$Especie.Sisflora[i], resolve$Especie.Resolvida[i]) == TRUE) {   
            resolve$Identicos[i] <- "Sim"
            } else {
                resolve$Identicos[i] <- "Nao"
            }
        }
    
# Cria o subset nomes.diferentes, com as espcies que no possuem nomes idnticos em
# resolve$Especie.Sisflora[i] e resolve$Especie.Resolvida[i]
    nomes.diferentes <- resolve[resolve$Identicos == "Nao"]

# Substitui os nomes das espcies em sisdof1 que no so idnticos a resolve$Especie.Resolvida
    
    x <- match(sisdof1$Especie, 
               nomes.diferentes$Especie.Sisflora)   # procura os nomes das especies de sisdof1 que esto presentes em nomes.diferentes$Especie.Sisflora. O resultado  o objeto x no qual iro aparecer as posies em nomes.diferentes$Especie.Sisflora que possuem nomes de especies de sisdof1$Especie 
    x <- x[!is.na(x)]                               # esse comando elimina de x os NAs. Dessa forma, x contm as posies em nomes.diferentes$Especie.Sisflora das especies de sisdof1$Especies com nomes escritos de forma errada e que devem ser substituido pelos nomes contidos em nomes.diferentes$Especie.Resolvida
    
    sisdof1$Especie[!is.na(match(sisdof1$Especie, 
                                         nomes.diferentes$Especie.Sisflora))] <-  nomes.diferentes$Especie.Resolvida[x]
    
    

# Teste para identificar se todas as espcies foram trocadas de forma satisfatria
    identical(length(unique(sisdof1$Especie)), length(unique(resolve$Especie.Resolvida)))
    
# Fusiona sisdof1 e sisdof2
    sisdof <- rbind(sisdof1, sisdof2)
    rm(nomes.diferentes, resolve, resolve.erro, 
       sisdof1, sisdof2, especie.erro, i, x)
    
# Deleta "." no final
    #length(grep("\\.+$", sisdof$Especie))
    sisdof$Especie <- gsub("\\.+$", "", sisdof$Especie)
    
# Substitui sinonmias na planilha sisdof que no foram resolvidas pela funo gnr_resolve.
# Essas sinonmias foram encontradas utilizando o script Seleo Espcies Movimentadas 
# As espcies mais movimentadas foram posteriormente usadas no portal Flora Brasil 2020 do 
# Jardim Botnico do Rio de Janeiro (http://floradobrasil.jbrj.gov.br/reflora/listaBrasil/)
# os nomes das espcies mais movimentadas foram pesquisadas e quando o site informou haver
# sinonmias, os nomes foram anotados. Segue a lista das sinonmias encontradas e
# o nome escolhido para ser utilizado:
    sisdof$Especie[sisdof$Especie == "Ruizterania albiflora"] <- "Qualea albiflora"
    sisdof$Especie[sisdof$Especie == "Handroanthus serratifolius"] <- "Tabebuia serratifolia"
    sisdof$Especie[sisdof$Especie == "Schizolobium parahyba"] <- "Schizolobium amazonicum"
    sisdof$Especie[sisdof$Especie == "Cedrelinga catenaeformis"] <- "Cedrelinga cateniformis"
    sisdof$Especie[sisdof$Especie == "Pseudopiptadenia suaveolens"] <- "Piptadenia suaveolens"
    sisdof$Especie[sisdof$Especie == "Newtonia suaveolens"] <- "Piptadenia suaveolens"
    sisdof$Especie[sisdof$Especie == "Nectandra rubra"] <- "Ocotea rubra"
    sisdof$Especie[sisdof$Especie == "Sextonia rubra"] <- "Ocotea rubra"
    sisdof$Especie[sisdof$Especie == "Apuleia molaris"] <- "Apuleia leiocarpa"
    
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas
    sisdof <- sisdof[, .(sum(Volume.Total), sum(Preco.Total)),
                     by = .(Tipo.de.Guia,
                            Tipo.de.Origem,
                            UF.Origem,
                            Municipio.Origem,
                            Cadastro.Destino,
                            Pais.Destino,
                            UF.Destino,
                            Municipio.Destino,
                            Emissao,
                            Especie,
                            Produto,
                            Unidade)]
    
# Renomeia as colunas V1 e V2  
    sisdof <- rename(sisdof,
                     "Volume.Total" = "V1",
                     "Preco.Total" = "V2")
    
# Grava sisdof aps padronizao dos nomes das espcies
    write.csv(sisdof, file = "Movimentacao Geral 2012 a 2017_10.Especie.csv") 
    
    write.csv(sisdof, file = "Movimentacao Geral 2012 a 2017_10.Especie2.csv") 
      
     
################################## Espcies Ameaadas ###################################### 
  
# Lista obtida no Portal Brasileiro de Dados Abertos em http://dados.gov.br/dataset/portaria_443/resource/11e8495f-3e37-4619-bb07-d77ed232b384
# URL do arquivo .csv: http://ckan.jbrj.gov.br/dataset/23f2e24c-5676-4acd-83f0-03621cba4364/resource/11e8495f-3e37-4619-bb07-d77ed232b384/download/especiesportaria443.csv
      
    ameacadas <- fread("especiesportaria443.csv")
    
    ameacadas <- ameacadas[-(1:5),-(1:2)]
      
    colnames(ameacadas) <- c("Especie","Portaria.443")  
    #ameacadas <- ameacadas[!grepl("CR", ameacadas$Espcie),]
      
    ameacadas<-ameacadas[(ameacadas$Portaria.443=="CR" 
                            | ameacadas$Portaria.443=="EN"
                            | ameacadas$Portaria.443=="VU"),]
      
# Elimina  linhas com NAs
      ameacadas <- ameacadas[complete.cases(ameacadas), ]
      
# Divide Gnero.e.Espcie e Resto
      ameacadas<-extract(ameacadas, Especie, c("Genero.e.Especie", "Resto"),
                         "(^[^\\s]+ [^\\s]+)(.*)")
      
# Elimina a coluna "Resto" da planilha "sinonimias"
      ameacadas$Resto<- NULL
      
# Cria o arquivo .csv da planilha ameacadas  
      write.csv(ameacadas, file ="Espcies Portaria 443.csv")
      
# Inclui a planilha "Portaria.443" na planilha sisdof
      sisdof<-merge(sisdof, ameacadas, 
                    by.x = "Especie",by.y = "Genero.e.Especie", all.x=TRUE)
        
      
######################################### Espcies Cites ###################################### 
      
# Arquivo .csv com Lista de espcies cites obtido no site https://www.speciesplus.net/species
# filtrado por reino Plantae e pas Brasil
      
  
# L a planilha das espcies de plantas contidas nos apndices I, II ou III da Cites.
  cites <- read.csv("cites_listings_2018-02-02 09_55_semicolon_separated.csv",
                    sep=";")[,c("Scientific.Name","Listing")]
      
  colnames(cites) <- c("Genero.e.Especie","Cites")  
  #ameacadas <- ameacadas[!grepl("CR", ameacadas$Espcie),]
  
# Cria o arquivo .csv da planilha cites  
  write.csv(cites, file = "Espcies Cites.csv")
      
# Inclui a coluna Cites na planilha sisfof
  sisdof <- merge(sisdof, cites, 
                  by.x = "Especie",by.y = "Genero.e.Especie", all.x=TRUE)
      
  
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas
  sisdof <- sisdof[, .(sum(Volume.Total), sum(Preco.Total)),
                   by = .(Tipo.de.Guia,
                          Tipo.de.Origem,
                          UF.Origem,
                          Municipio.Origem,
                          Cadastro.Destino,
                          Pais.Destino,
                          UF.Destino,
                          Municipio.Destino,
                          Emissao,
                          Especie,
                          Portaria.443,
                          Cites,
                          Produto,
                          Unidade)]
  
# Renomeia as colunas V1 e V2  
  sisdof <- rename(sisdof,
                   "Volume.Total" = "V1",
                   "Preco.Total" = "V2")
  
  
# Cria o arquivo .csv da planilha sisdof, agora com as colunas "Portaria.443" e "Cites"  
  write.csv(sisdof, file ="Movimentacao Geral 2012 a 2017_Cites.443.csv")
  
  rm(ameacadas, cites)
  
  
#### 7. Produto ####
  
# Todas para minuscula
  sisdof$Produto <- tolower(sisdof$Produto)
  
# Elimina os acentos ortogrficos
  sisdof$Produto <- stri_trans_general(sisdof$Produto, "Latin-ASCII")
  
# Troca espaos por "."
  sisdof$Produto <- gsub("\\s+", ".", sisdof$Produto)

# Deletar "." no final, se houver
  #grep("\\.$", sisdof$Produto)   #Testa se h municpios com "." no final, caso positivo executar o comando abaixo:
  sisdof$Produto <- gsub("\\.$", "", sisdof$Produto)
  
# Agregar todos os tipos de Compensado
  sisdof$Produto <- sub("(?<=compensado).*$", "", sisdof$Produto, perl=TRUE)
  
# Criar categoria "Produto.Isento.de.DOF"
  sisdof$Produto <- recode(sisdof$Produto, 
                               aglomerado = "Produto.Isento.de.DOF",
                               briquete = "Produto.Isento.de.DOF",
                               casca = "Produto.Isento.de.DOF",
                               manta.sarrafeada = "Produto.Isento.de.DOF",
                               muda = "Produto.Isento.de.DOF",
                               piso.engenheirado = "Produto.Isento.de.DOF",
                               serragem = "Produto.Isento.de.DOF")
  
# Consolidar sinnimos
  # bloco, quadrado ou fil
  # unique(sisdof$Produto[grep("^bloco", sisdof$Produto)])
  sisdof$Produto[sisdof$Produto == "bloco"] <- "bloco,.quadrado.ou.file"
  sisdof$Produto[sisdof$Produto == "file"] <- "bloco,.quadrado.ou.file"
  
  # cavaco
  #unique(sisdof$Produto[grep("^cavaco", sisdof$Produto)])
  sisdof$Produto[sisdof$Produto == "cavacos"] <- "cavaco"
  
  # domente
  #unique(sisdof$Produto[grep("^dormente", sisdof$Produto)])
  sisdof$Produto[sisdof$Produto == "dormente.serrada"] <- "dormente"
  
  # Lascas
  #unique(sisdof$Produto[grep("^lasca", sisdof$Produto)])
  sisdof$Produto[sisdof$Produto == "lascas.e.achas"] <- "lascas"
  sisdof$Produto[sisdof$Produto == "lascas.(st)"] <- "lascas"
  
  # Madeira Laminada Torneada e lamina.desenrolada
  sisdof$Produto[sisdof$Produto == "lamina.desenrolada"] <- "madeira.laminada.torneada"
  sisdof$Produto[sisdof$Produto == "madeira.laminada.torneada"] <- "lamina.desenrolada"
  
  # Madeira Laminada Faqueada e Lmina Faqueada
  sisdof$Produto[sisdof$Produto == "madeira.laminada.faqueada"] <- "lamina.faqueada"
  
  # caibro
  #unique(sisdof$Produto[grep("caibro", sisdof$Produto)])
  sisdof$Produto[sisdof$Produto == "caibro"] <- "madeira.serrada.(caibro)"
  
  # Madeira serrada (prancha)
  #unique(sisdof$Produto[grep("prancha", sisdof$Produto)])
  sisdof$Produto[sisdof$Produto == "prancha"] <- "madeira.serrada.(prancha)"
  
  # Madeira serrada (prancho desdobrado)
  #unique(sisdof$Produto[grep("pranchao", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "pranchao"])
  sisdof$Produto[sisdof$Produto == "pranchao"] <- "madeira.serrada.(pranchao.desdobrado)"
  
  # Madeira serrada (tbua) e tabua
  #unique(sisdof$Produto[grep("tabua", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "tabua"])
  #length(sisdof$Produto[sisdof$Produto == "madeira.serrada.(tabua)"])
  sisdof$Produto[sisdof$Produto == "tabua"] <- "madeira.serrada.(tabua)"
  
  # Madeira serrada (viga) e viga
  #unique(sisdof$Produto[grep("viga", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "viga"])
  #length(sisdof$Produto[sisdof$Produto == "madeira.serrada.(viga)"])
  sisdof$Produto[sisdof$Produto == "viga"] <- "madeira.serrada.(viga)"
  
  # Madeira serrada (vigota)
  #unique(sisdof$Produto[grep("vigota", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "vigota"])
  #length(sisdof$Produto[sisdof$Produto == "madeira.serrada.(vigota)"])
  sisdof$Produto[sisdof$Produto == "vigota"] <- "madeira.serrada.(vigota)"
  
  # Madeira Aplainada 2 Faces (S2S), Madeira Serrada Aplainada 2 Faces e 
  # Tbua Aplainada 2 Faces (S2S)
  #length(sisdof$Produto[sisdof$Produto == "madeira.aplainada.2.faces.(s2s)"])
  #length(sisdof$Produto[sisdof$Produto == "madeira.serrada.aplainada.2.faces"])
  #length(sisdof$Produto[sisdof$Produto == "tabua.aplainada.2.faces.(s2s)"])
  sisdof$Produto[sisdof$Produto == "madeira.aplainada.2.faces.(s2s)"] <- "madeira.serrada.aplainada.2.faces"
  sisdof$Produto[sisdof$Produto == "tabua.aplainada.2.faces.(s2s)"] <- "madeira.serrada.aplainada.2.faces"
  
  # Madeira Aplainada 4 Faces (S4S), Madeira Serrada Aplainada 4 Faces e
  # Tbua Aplainada 4 Faces (S4S)
  #length(sisdof$Produto[sisdof$Produto == "madeira.aplainada.4.faces.(s4s)"])
  #length(sisdof$Produto[sisdof$Produto == "madeira.serrada.aplainada.4.faces"])
  #length(sisdof$Produto[sisdof$Produto == "tabua.aplainada.4.faces.(s4s)"])
  sisdof$Produto[sisdof$Produto == "madeira.aplainada.4.faces.(s4s)"] <- "madeira.serrada.aplainada.4.faces"
  sisdof$Produto[sisdof$Produto == "tabua.aplainada.4.faces.(s4s)"] <- "madeira.serrada.aplainada.2.faces"
  
  # Moures, Moures (st) e Moures ou Moires
  #unique(sisdof$Produto[grep("mouroes", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "mouroes"])
  #length(sisdof$Produto[sisdof$Produto == "mouroes.ou.moiroes"])
  #length(sisdof$Produto[sisdof$Produto == "mouroes.(st)"])
  sisdof$Produto[sisdof$Produto == "mouroes.ou.moiroes"] <- "mouroes"
  sisdof$Produto[sisdof$Produto == "mouroes.(st)"] <- "mouroes"
  
  # Palanques Rolios, Palanques rolios (st)
  #unique(sisdof$Produto[grep("palanques", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "palanques.rolicos"])
  #length(sisdof$Produto[sisdof$Produto == "palanques.rolicos.(st)"])
  sisdof$Produto[sisdof$Produto == "palanques.rolicos.(st)"] <- "palanques.rolicos"
  
  # Portal, Portal ou Batente
  #unique(sisdof$Produto[grep("portal", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "portal.ou.batente"])
  length(sisdof$Produto[sisdof$Produto == "portal"])
  sisdof$Produto[sisdof$Produto == "portal"] <- "portal.ou.batente"
  
  # Poste e Postes no Imunizados
  #unique(sisdof$Produto[grep("poste", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "poste"])
  #length(sisdof$Produto[sisdof$Produto == "postes.nao.imunizados"])
  sisdof$Produto[sisdof$Produto == "postes.nao.imunizados"] <- "poste"
  
  # Ripa e Ripas
  #unique(sisdof$Produto[grep("ripa", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "ripa"])
  #length(sisdof$Produto[sisdof$Produto == "ripas"])
  sisdof$Produto[sisdof$Produto == "ripa"] <- "ripas"
  
  # Toretes e Toretes (st)
  #unique(sisdof$Produto[grep("torete", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "toretes"])
  #length(sisdof$Produto[sisdof$Produto == "toretes.(st)"])
  sisdof$Produto[sisdof$Produto == "toretes.(st)"] <- "toretes"
  
  # Escoramento e escoramento (st)
  #unique(sisdof$Produto[grep("escoramento", sisdof$Produto)])
  #length(sisdof$Produto[sisdof$Produto == "escoramento"])
  #length(sisdof$Produto[sisdof$Produto == "escoramento.(st)"])
  sisdof$Produto[sisdof$Produto == "escoramento.(st)"] <- "escoramento"
  
  # Carvao
  #unique(sisdof$Produto[grep("carvao", sisdof$Produto)])
  sisdof$Produto <- sub("(?<=carvao).*$", "", sisdof$Produto, perl=TRUE)
  
  # Lenha
  #unique(sisdof$Produto[grep("lenha", sisdof$Produto)])
  sisdof$Produto <- sub("(?<=lenha).*$", "", sisdof$Produto, perl=TRUE)
  
  # Produtos no madeireiros:
  # cipo, ferro.gusa, folhas, oleos.essenciais, palmitos, planta.viva, xaxim.(st)
  #length(sisdof$Produto[sisdof$Produto == "oleos.essenciais"])
  #unique(sisdof$Produto[grep("palmito", sisdof$Produto)])
  
  sisdof$Produto[sisdof$Produto == "cipo"] <- "Produto.Nao.Madeireiro"
  sisdof$Produto[sisdof$Produto == "ferro.gusa"] <- "Produto.Nao.Madeireiro"
  sisdof$Produto[sisdof$Produto == "oleos.essenciais"] <- "Produto.Nao.Madeireiro"
  sisdof$Produto <- sub("(?<=palmito).*$", "", sisdof$Produto, perl=TRUE)
  sisdof$Produto[sisdof$Produto == "planta.viva"] <- "Produto.Nao.Madeireiro"
  sisdof$Produto[sisdof$Produto == "xaxim.(st)"] <- "Produto.Nao.Madeireiro"
  
  # Resduos
  sisdof$Produto <- sub("(?<=residuos).*$", "", sisdof$Produto, perl=TRUE)
  sisdof$Produto[sisdof$Produto == "residuo"] <- "residuos"
  
  # Toras
  #unique(sisdof$Produto[grep("tora", sisdof$Produto)])
  sisdof$Produto[sisdof$Produto == "toras.de.madeira.nativa"] <- "tora"
  sisdof$Produto[sisdof$Produto == "toras.de.madeira.produzida"] <- "tora"
  
# Agrega a soma do volume total e do preo total conforme as colunas escolhidas
  sisdof <- sisdof[, .(sum(Volume.Total), sum(Preco.Total)),
                   by = .(Tipo.de.Guia,
                          Tipo.de.Origem,
                          UF.Origem,
                          Municipio.Origem,
                          Cadastro.Destino,
                          Pais.Destino,
                          UF.Destino,
                          Municipio.Destino,
                          Emissao,
                          Especie,
                          Portaria.443,
                          Cites,
                          Produto,
                          Unidade)]
  
# Renomeia as colunas V1 e V2  
  sisdof <- rename(sisdof,
                   "Volume.Total" = "V1",
                   "Preco.Total" = "V2")
  
  
# Cria o arquivo .csv da planilha sisdof, agora com as colunas "Portaria.443" e "Cites"  
  write.csv(sisdof, file = "Movimentacao Geral 2012 a 2017_11.Produto.csv")
  
#### 8. Unidade ####
# Conforme o manual de fiscalizacao do Ibama foi adotada a converso de 1m3 = 1.5 st
# Descartar outras unidades alm de m3 e st
  
# Para minuscula
  sisdof$Unidade <- tolower(sisdof$Unidade)
  

# Cria subset de sisdof apenas com unidade "st" 
  sisdof1 <- sisdof[sisdof$Unidade == "st"]
  
# Cria subset de sisdof apenas com unidade "m3" 
  sisdof2 <- sisdof[sisdof$Unidade == "m3"]

# Converte "st" para "m3", dividindo o volume em "st" por 1,5
# Essa transformao foi utilizada conforme Manual de Fiscalizao do Ibama. 
  sisdof1$Volume.Total <- sisdof1$Volume.Total / 1.5
  
# Transforma os valores "st" da coluna Unidade em "m3"
  sisdof1$Unidade <- "m3"
  
# Fusiona sisdof1 e sisdof2
  sisdof <- rbind(sisdof1, sisdof2)
 
# Remove sisdof1 e sisdof2
    rm(sisdof1, sisdof2)
 
# Cria as colunas Grupo com valor "Nao.se.Aplica". Essa coluna ira conter os diferentes 
# grupos de espcies (geral e grupos 1, 2 e 3). 
    
    sisdof$Grupo <- "Nao.se.aplica"
    
#### 2. Tipo.de.Origem ####
    
    # Troca espaos duplos, se houver, por "."
    #grep("\\s{2,}", sisdof$Tipo.de.Origem)   #Testa se h municpios com "." no final, caso positivo executar o comando abaixo:
    sisdof$Tipo.de.Origem <- gsub("\\s{2,}", ".", sisdof$Tipo.de.Origem)
    # Troca espaos no final, se houver por "."
    #grep("\\s+$", sisdof$Tipo.de.Origem)    #Testa se h municpios com espao em branco no final, caso positivo executar o comando abaixo:
    sisdof$Tipo.de.Origem <- gsub("\\s+", ".", sisdof$Tipo.de.Origem)
    # Troca espaos por "."
    sisdof$Tipo.de.Origem <- gsub(" ", ".", sisdof$Tipo.de.Origem)
    
    # Cria categorias de tipos de origem, unindo nomeclaturas do DOF e Sisflora Grosso
    sisdof$Tipo.de.Origem <- sub("(?<=PMFS).*$", "", sisdof$Tipo.de.Origem, perl=TRUE)      # remove caracteres que esto aps "PMFS". We use a positive lookbehind ((?<=Patio).*) to match one or more character (.) that is preceded by Patio and replace it with "".
    
    sisdof$Tipo.de.Origem <- sub("(?<=PEF).*$", "", sisdof$Tipo.de.Origem, perl=TRUE)      # remove caracteres que esto aps "PEF". We use a positive lookbehind ((?<=Patio).*) to match one or more character (.) that is preceded by Patio and replace it with "".
    
    # Segundo dados do Sisflora Mato Grosso, PEF = Projeto de Exploracao Florestal. AD = Autorizacao de Desmatamento
    # AEF = Autorizacao de Exploracao Vegetal
    
    # Cria o grupo "Supresso.Vegetal"
    sisdof$Tipo.de.Origem[sisdof$Tipo.de.Origem == "PEF" |
                              sisdof$Tipo.de.Origem == "DALI" |                 # Desmatamento Autorizado para a Licenca de Instalacao
                              sisdof$Tipo.de.Origem == "Autorizacao.de.Supressao.de.Vegetacao" |
                              sisdof$Tipo.de.Origem == "Uso.Alternativo.do.Solo" |
                              sisdof$Tipo.de.Origem == "AUMP" |
                              sisdof$Tipo.de.Origem == "AUAS" |
                              sisdof$Tipo.de.Origem == "CRIPS.(AUMP)" |
                              sisdof$Tipo.de.Origem == "CRIPS.(AUAS)"] <- "Supresso Vegetal"
    
    # Cria o grupo CAI == "Corte.de.Arvores.Isoladas"
    sisdof$Tipo.de.Origem[sisdof$Tipo.de.Origem == "Corte.de.Arvores.Isoladas" |
                            sisdof$Tipo.de.Origem == "CPAU" |
                            sisdof$Tipo.de.Origem == "PFLP.(AUMP)"] <- "Corte de rvores Isoladas (CAI)" 
    
    # Cria o grupo Plantios.Florestais = RCEN e "Floresta.Plantada"
    sisdof$Tipo.de.Origem[sisdof$Tipo.de.Origem == "RCEN" |
                              sisdof$Tipo.de.Origem == "Floresta.Plantada"] <- "Plantios Florestais" 
    
    sisdof$Tipo.de.Origem[sisdof$Tipo.de.Origem == "PMFS" |
                            sisdof$Tipo.de.Origem == "EFPP" |
                            sisdof$Tipo.de.Origem == "AUTEF" |
                            sisdof$Tipo.de.Origem == "EFPP.(AD)" |
                            sisdof$Tipo.de.Origem == "AUTEX" |
                            sisdof$Tipo.de.Origem == "EFPP.(AEF)"] <- "Plano de Manejo Florestal Sustentvel (PMFS)"
    
    sisdof$Preco.Total <- as.numeric(sisdof$Preco.Total)

# Agrega a soma do volume total e do preo total conforme as colunas escolhidas
    sisdof <- sisdof[, .(sum(Volume.Total), sum(Preco.Total)),
                     by = .(Tipo.de.Guia,
                            Tipo.de.Origem,
                            UF.Origem,
                            Municipio.Origem,
                            Cadastro.Destino,
                            Pais.Destino,
                            UF.Destino,
                            Municipio.Destino,
                            Emissao,
                            Especie,
                            Portaria.443,
                            Cites,
                            Produto,
                            Unidade,
                            Grupo)]
    
    # Renomeia as colunas V1 e V2  
    sisdof <- rename(sisdof,
                     "Volume.Total" = "V1",
                     "Preco.Total" = "V2")
    
# Cria o arquivo .csv da planilha sisdof aps padronizar todas as variveis  
    write.csv(sisdof, file = "Movimentacao Geral 2012 a 2017.Final.csv")
    
    
   
    
                                                 